#include <DVDPlayback/DVDPlayback.h>
#ifndef PANTHER
extern "C" { extern void DVDCopyBuildVersion(); }
#endif

#import <Cocoa/Cocoa.h>
#include <AppKit/NSApplication.h>
#include <AppKit/NSAlert.h>
//#include <CoreGraphics/CGDirectDisplay.h>
#include <Foundation/NSTimer.h>

#include <mach-o/dyld.h>

#include "DVDVideo.h"

#include "avcodec.h"
#include "dvdv.h"   // for gDVDVState

#define PANTHER

#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>


/*
Turn on the define below if you want to use the normal DVDPlayback API
and not the lower-level reverse-engineered DVDVideo API. Of course you will
need to have a proper VIDEO_TS folder with all the right IFOs and BUPs
if you turn it on.
*/
//#define PLAY_WITH_DVDPLAYBACK

#ifndef PLAY_WITH_DVDPLAYBACK
/**
 *  If LOWLEVEL_OURSELF is turned off, then we let DVDPlayback do all the
 *  talking to DVDVideo, and we just substitute our image data for what it
 *  would send. It's a good way of narrowing down a problem when something
 *  isn't working. However, the two files must obviously be quite similar.
 *  The dummy DVD used is gDummyDVDPath, so make sure it exists.
 */
#define LOWLEVEL_OURSELF

struct DummyDVD
{
	uint16	width;
	uint16	height;
	const char * path;
} gDummyDVDs[] =
{
	{ 720, 576, "Dummy576pDVD/VIDEO_TS" },		// 576p
	{ 1280, 720, "Dummy720pDVD/VIDEO_TS" },		// 720p
	{ 1920, 1088, "Dummy1080iDVD/VIDEO_TS" }	// 1080i
};
#endif


char * gFileToOpen = NULL;


int main( int argc, const char *argv[] )
{
	if (argc == 2)
	{
		struct stat sb;
		if (stat( argv[1], &sb ) >= 0)
			gFileToOpen = (char*)argv[1];
	}

    return NSApplicationMain(argc, argv);
}


@interface AppDelegate : NSObject
{
	NSWindow * window;
	BOOL		playingNow;
}

- (void)idleTimer:(NSTimer *)timer;

@end




int ptrace_replaced( int r3 )
{
	return r3;  // ought to consider returning 0 or something
}

int exit_replaced( int r3 )
{
	return r3;
}

static void replaceDyldStubFromJumpInstruction( char * jumpInst, void * newFn )
{
	char * stubCode = jumpInst+((*(uint32*)jumpInst)&0x00FFFFFC);
	printf( "jump at 0x%08X so stub code at 0x%08X\n",
		(uint)jumpInst, (uint)stubCode );
	// *(uint32*)stubCode = 0x4e800020;  // blr
#ifdef PANTHER
	uint32 stubDist = (*(uint16*)(stubCode+18) << 16) | *(uint16*)(stubCode+22);
#else
	uint32 stubDist = (*(uint16*)(stubCode+14) << 16) + *(sint16*)(stubCode+22);
#endif
	uint32 * stubData = (uint32*)(stubCode+8 + stubDist);
	printf( "stub data at 0x%08X was 0x%08X now 0x%08X\n",
		(uint)stubData, (uint)*stubData, (uint)newFn );
	(void*&)*stubData = newFn;
}



DVDVideoContext * gDVDContext;
int gSurfaceID;
short gRealRect[4] = { 0, 0, 0, 0 };

typedef uint32 (*DVDSetMPRectsType)( DVDVideoContext * context, short * rect, int flags1, int flags2 );

static DVDSetMPRectsType gOrigSMPR;

uint32 DVDSetMPRects_collect( DVDVideoContext * context, short * rect, int surfaceID1, int surfaceID2 )
{
	if (gDVDContext == NULL && gRealRect[2] <= rect[2] && gRealRect[3] <= rect[3])
	{
		gDVDContext = context;
		gSurfaceID = surfaceID1;
		printf( "SetMPRects_collect: Got correct DVD context 0x%08X and surface ID 0x%08X\n",
			(int)gDVDContext, gSurfaceID );
		printf( "SetMPRects_collect: Our surface is %dx%d pixels big\n", rect[3], rect[2] );
	}
	
	return (*gOrigSMPR)( context, gRealRect/*replaced*/, surfaceID1, surfaceID2 );
}



typedef uint32 (*DVDDecodeType)( DVDVideoContext * context, DecodeParams * params, uint16 * rect, uint32 unknownZero );

static DVDDecodeType gOrigDecoder;
static const char s_pictTypes[] = { '?', 'I', 'P', 'B' };

uint32 DVDDecode_filter( DVDVideoContext * context, DecodeParams * params, uint16 * rect, uint32 unknownZero )
{
	int * up = (int*)params;
	printf( "params hex %08X %08X %08X %08X %08X %08X %08X %08X\n",
		up[0], up[1], up[2], up[3], up[4], up[5], up[6], up[7] );
	printf( "pictType %c dstBuf %d srcBufs %d %d\n", s_pictTypes[params->pictType],
		params->dstBuf, params->srcBufL, params->srcBufR );
	if (params->sevenSixEight != 768)
		printf( "\n\n========= sevenSixEight = %d instead of 768! =========\n\n\n", params->sevenSixEight );
	printf( "rect (%d,%d)-(%d,%d)\n", rect[0], rect[1], rect[2], rect[3] );
	
	int mbCount = (rect[3]/16)*(rect[2]/16);
	mbCount = 4;   // for testing
	
	int * p = 0;
	for (int i = 0; i < mbCount; i++)
	{
		MBInfo & mbi = params->mbInfo[i];
		printf( "mbInfo %3d: m %08X %08X %08X %08X f %02X %02X %02X %02X mbtype %02X ildct %d n %d %d %d %d %d %d\n",
			i, mbi.mv0, mbi.mv1, mbi.mv2, mbi.mv3,
			mbi.fieldSelect[0], mbi.fieldSelect[1], mbi.fieldSelect[2], mbi.fieldSelect[3],
			mbi.mbType, mbi.interlacedDCT,
			mbi.n[0], mbi.n[1], mbi.n[2], mbi.n[3], mbi.n[4], mbi.n[5] );
	}
	printf( "\n" );
	p = (int*)params->dctSpecs;
	for (int i = 0; i < mbCount; i++)
	{
		printf( "dctSpecs %d\n", i );
		MBInfo & mbi = params->mbInfo[i];
		for (int b = 0; b < 6; b++)
		{
			printf( " b%d:", b );
			for (int j = 0; j < mbi.n[b]; j++)
			{
				DCTSpec & s = *(DCTSpec*)p++;
				if (s.runSubOne != 0) printf( " (run %d)", s.runSubOne+1 );
				printf( " %04X", (uint16)(s.elt) );
			}
			printf( "\n");
		}
	}
	p = (int*)params->cbp;
	for (int i = 0; i < (mbCount+31)/32; i++)
	{
		printf( "p3 data: %08X %08X %08X %08X %08X %08X %08X %08X\n",
			p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7] );
		p+=8;
	}

	/*
	// p4 always zero ... subpicture?
	p = (int*)params->p4;
	printf( "p4 data: %08X %08X %08X %08X %08X %08X %08X %08X\n",
		p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7] );
	*/
	
	if (params->completionInfo != NULL)
	{
		p = (int*)params->completionInfo;//->frameDataToDisplay;
		printf( "display frame %d @0x%08X: %08X %08X %08X %08X %08X %08X %08X %08X\n",
			params->completionInfo->frameNumberToDisplay,
			(int)p, p[8], p[9], p[10], p[11], p[12], p[13], p[14], p[15] );
	}
	
	printf( "\n\n" );
	
	return (*gOrigDecoder)( context, params, rect, unknownZero );
}

AVCodecContext * avctx;
AVFrame * pic;

uint8 * gSBBeg, * gSBEnd;
struct DVDV_CurPtrs begPtrs;

// this function substitutes coded data from ffmepg for coded data from DVDPlayback
uint32 DVDDecode_subst( DVDVideoContext * context, DecodeParams * params, uint16 * rect, uint32 unknownZero )
{
	#ifdef LOWLEVEL_OURSELF
	return 0;	// don't pass it on if we're not expecting decode calls!
	// this only happens when we need to use a dummy dvd to set up the device
	#endif

	static int nframes = 0;
	++nframes;
	if (gSBEnd-gSBBeg < 256*1024)
	{
		return DVDDecode_filter( context, params, rect, unknownZero );
	}

	int got_pic = 0;
	while (!got_pic)
	{
		gDVDVState = begPtrs;

		int ulen = avcodec_decode_video( avctx, pic, &got_pic, gSBBeg, gSBEnd-gSBBeg );
		if (!got_pic && (nframes > 1 || gSBEnd-gSBBeg < 256*1024)) break;
		gSBBeg += ulen;
		
		if (gDVDVState.mb == begPtrs.mb)
		{
			printf( "didn't decode any data so skipping frame\n" );
			got_pic = false;
			continue;
		}

		printf( "used %d got picture(%d) from ffmpeg pict_type %c\n",
			ulen, got_pic, s_pictTypes[ pic->pict_type ] );
	}
	
	if (!got_pic)
	{
		return DVDDecode_filter( context, params, rect, unknownZero );
	}
	else
	{
		printf( "replacing DecodeParams with my own\n" );
		DecodeParams mp = *params;
		mp.mbInfo = (MBInfo*)begPtrs.mb;
		mp.dctSpecs = (DCTSpec*)begPtrs.dct;
		mp.cbp = begPtrs.cbp;
		
#if 0 // enable to verify decoding, when dummy and real files are the same
		DCTSpec * specatOth = params->dctSpecs;
		DCTSpec * specatOwn = mp.dctSpecs;

		if (nframes < 32)
		{
			for (int i = 0; i < (rect[3]/16)*(rect[2]/16); i++)
			{
				if (mp.mbInfo[i].mbType != params->mbInfo[i].mbType ||
					memcmp( &mp.mbInfo[i].n, &params->mbInfo[i].n, 6 ) != 0)
				{
					printf( "frame %d, mb info elt %d differs (good,bad):\n", nframes-1, i );
					for (int g = 0; g < 2; g++)
					{
						MBInfo & mbi = (g ? mp : *params).mbInfo[i];
						printf( "mbInfo %3d: m %08X %08X %08X %08X f %02X %02X %02X %02X mbtype %02X ildct %d n %d %d %d %d %d %d\n",
							i, mbi.mv0, mbi.mv1, mbi.mv2, mbi.mv3,
							mbi.fieldSelect[0], mbi.fieldSelect[1], mbi.fieldSelect[2], mbi.fieldSelect[3],
							mbi.mbType, mbi.interlacedDCT,
							mbi.n[0], mbi.n[1], mbi.n[2], mbi.n[3], mbi.n[4], mbi.n[5] );
					}
				}
				MBInfo & mbi = mp.mbInfo[i];
				for (uint b = 0; b < 6; b++)
				{
					bool equiv = true;
					for (uint j = 0; j < mbi.n[b]; j++)
					{
						equiv &= (specatOwn[j].runSubOne == specatOth[j].runSubOne);
						equiv &= (specatOwn[j].elt == specatOth[j].elt);
					}
					//if (memcmp( specatOth, specatOwn, mbi.n[b]*sizeof(DCTSpec) ) != 0)
					if (!equiv)
					{
						printf( "frame %d mb %d, dct spec block %d differs (good,bad):\n", nframes-1, i, b );
						for (int g = 0; g < 2; g++)
						{
							DCTSpec * p = g ? specatOwn : specatOth;
							printf( " b%d:", b );
							for (int j = 0; j < mbi.n[b]; j++)
							{
								DCTSpec & s = *p++;
								if (s.runSubOne != 0) printf( " (run %d)", s.runSubOne+1 );
								printf( " %04X", (uint16)(s.elt) );
							}
							printf( "\n");
						}
					}
					specatOth += mbi.n[b];
					specatOwn += mbi.n[b];
				}
			}
		}
		
		return (*gOrigDecoder)( context, params, rect, unknownZero );
#endif

		//return DVDDecode_filter( context, &mp, rect, unknownZero ); // normally this
		return (*gOrigDecoder)( context, &mp, rect, unknownZero );
		//return DVDVideoDecode( context, &mp, rect, unknownZero );
	}
}


typedef int (*DVDLoggerGeneric)( int a, int b, int c, int d, int e, int f, int g, int h );

typedef struct LogBegin { static int addLog( void ** pfrom, void ** pto ) { return 0; } }



#define DVD_LOGAND( OF, NARGS, PTRS, SKIP )					\
LogPrev_##OF;												\
int DVDLogger_##OF( int a, int b=0, int c=0, int d=0, int e=0, int f=0, int g=0, int h=0 )\
{															\
	if (SKIP) return 0;										\
															\
	int args[8] = { a, b, c, d, e, f, g, h };				\
	printf( #OF ":" );										\
	for (int i = 0; i < NARGS; i++) printf( " %08X", args[i] );\
	printf( "\n" );											\
															\
	DVDLoggerGeneric fn = (DVDLoggerGeneric)&DVDVideo##OF;  \
	if (SKIP) { printf( "skipping " #OF "\n" ); return 0; } \
	int ret = (*fn)( a, b, c, d, e, f, g, h );				\
	if (ret != 0) printf( "returned %08X\n", ret );			\
															\
	for (int i = 0; i < NARGS; i++)							\
	{														\
		if (args[i] == 0 || !((PTRS) & (1<<i))) continue;\
		int * p = (int*)args[i];							\
		printf( " ptr %d: %08X %08X %08X %08X %08X %08X %08X %08X\n", i,\
			p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7] );\
	}														\
															\
	return ret;												\
}															\
typedef struct LogNext_##OF									\
{															\
	static int addLog( void ** pfrom, void ** pto )			\
	{														\
		int n = LogPrev_##OF::addLog( pfrom, pto );			\
		pfrom[n] = (void*)DVDVideo##OF;						\
		pto[n] = (void*)DVDLogger_##OF;						\
		return n+1;											\
	}														\
}															\

#define DVD_LOGNOR( OF, NARGS, PTRS ) DVD_LOGAND( OF, NARGS, PTRS, 0 )
#define DVD_LOGGER( OF ) DVD_LOGAND( OF, 1, 0, 1 )


DVD_LOGNOR( OpenDevice, 7, (1<<4)+(1<<5)+(1<<6) )
DVD_LOGNOR( CloseDevice, 2, 0 )
DVD_LOGNOR( SetMVLevel, 2, 0 )
DVD_LOGNOR( ClearMP, 1, 0 )
DVD_LOGNOR( SetMPRects, 4, 2 )
DVD_LOGNOR( EnableMP, 2, 0 )
DVD_LOGAND( SetFeatureParam, 3, 0, 1 )
DVD_LOGNOR( Decode, 4, 2+4 )
DVD_LOGNOR( Deinterlace, 4, 2+4+8 )
DVD_LOGNOR( ShowMPBuffer, 4, 4+8 )


DVD_LOGGER( GetFeatureParam )
DVD_LOGGER( GetKeyColor )
DVD_LOGGER( EnableSP )
DVD_LOGGER( ClearSP )
DVD_LOGGER( ShowSPBuffer )
DVD_LOGGER( SetSPPalette )
DVD_LOGGER( SetSPColorControl )
DVD_LOGGER( SetSPDefaultColorControl )
DVD_LOGGER( SetSPBuffer )
DVD_LOGGER( GetSPBuffer )
DVD_LOGGER( ApplySPDCSQ )
DVD_LOGGER( CreateRenderer )
DVD_LOGGER( FrontEndDecode )
DVD_LOGGER( BackEndDecode )
DVD_LOGGER( FrontEndAndBackEndDecode )
DVD_LOGGER( BeginDecode )
DVD_LOGGER( ContinueDecode )
DVD_LOGGER( EndDecode )
DVD_LOGGER( PrepareButton )
DVD_LOGGER( EnableButton )
DVD_LOGGER( GetFrame )

/*typedef struct... */ LogEnd;


typedef int (*DVDVideoOpenDeviceFunc)(
	CGDirectDisplayID cgDisplayID, int CGSConnectionID, int windowNum, int surfaceID,
	const short * rectIn, void * othOut, DVDVideoContext ** ppContext, int unk1 );

DVDVideoOpenDeviceFunc gOrigOpenDevice;
static int DVDVideoOpenDevice_filter(
	CGDirectDisplayID cgDisplayID, int cgSConnectionID, int windowNum, int surfaceID,
	const short * rectIn, void * othOut, DVDVideoContext ** ppContext, int unk1 )
{
	// clear DVDContext as it would otherwise now be stale
	gDVDContext = NULL;
	// (it should only be set when we get a surface of the correct size with it)

	return (*gOrigOpenDevice)(
		cgDisplayID, cgSConnectionID, windowNum, surfaceID,
		gRealRect, //replaced
		othOut, ppContext, unk1 );
}



static uint64 getusecs()
{
	struct timeval tv;
	gettimeofday( &tv, NULL );
	return uint64(tv.tv_sec)*1000000 + tv.tv_usec;
}


#ifndef PLAY_WITH_DVDPLAYBACK
static void * AccellentDVDDecodeThread( void * /*args*/ );
pthread_t gDecThread;
bool gStop = false;
#endif


@implementation AppDelegate

- (void)awakeFromNib
{
	playingNow = NO;
}



- (BOOL)application:(NSApplication *)sender openFile:(NSString *)filename
{
	const char * filenameCStr = [filename lossyCString];
	gFileToOpen = new char[strlen(filenameCStr)+1];
	strcpy( gFileToOpen, filenameCStr );

	printf( "Asked to open file '%s'\n", gFileToOpen );
	return true;
}

- (BOOL)applicationShouldOpenUntitledFile:(NSApplication *)sender
{
	printf( "\nAsked about untitled files\n\n" );
	return TRUE;
}

- (BOOL)applicationOpenUntitledFile:(NSApplication *)sender
{
	printf( "\nAsked to open untitled file\n\n" );
	return TRUE;
}

#define TGOOD ++step; if (err != 0) { printf( "error 0x%08X at step %d\n", (int)err, step ); }

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
	OSStatus err;
	int step = 0;

	// first make it so we can use gdb
	/*
	NSSymbol initSym = NSLookupAndBindSymbol( "_DVDInitialize" );
	printf( "initSym is 0x%08X funcptr is 0x%08X\n", initSym, (void*)DVDInitialize );
	NSModule playbackModule = NSModuleForSymbol( initSym );
	printf( "playbackModule is 0x%08X\n", playbackModule );
	NSSymbol ptraceSym = NSLookupSymbolInModule( playbackModule, "ptrace" );
	printf( "ptraceSym is 0x%08X\n", ptraceSym );
	*/
	/*
	struct mach_header * playbackImage =
		_dyld_get_image_header_containing_address( DVDInitialize );
	printf( "playbackImage is 0x%08X\n", playbackImage );
	printf( "ptraceSym is defined:%s\n",
		NSIsSymbolNameDefinedInImage( playbackImage, "dyld_stub_ptrace" ) ? "YES":"NO" );
	*/
	// too hard to find the symbol's dyld stub properly.. find it via known callers in code
	// (it seems only gdb knows about dyld_stub_xxx; these numbers are from lr's sighted there)
#ifdef PANTHER
	char * wakeupStart = (char*)DVDWakeUp;
	char * ptraceJump = wakeupStart+524316;
	char * exitJump = wakeupStart+524332;
	char * decodeCallerStart = wakeupStart+406868;
#else
	char * copyBuildVersionStart = (char*)DVDCopyBuildVersion;
	char * ptraceJump = copyBuildVersionStart+859516;
	char * exitJump = copyBuildVersionStart+859544;
	char * decodeCallerStart = copyBuildVersionStart+742068;
#endif
	printf( "replacing nasty functions preventing debugging...\n" );
	replaceDyldStubFromJumpInstruction( ptraceJump, (void*)ptrace_replaced );
	replaceDyldStubFromJumpInstruction( exitJump, (void*)exit_replaced );
	printf( "done\n" );




	printf( "probing file with libavcodec\n" );
	avcodec_init();
	//avcodec_register_all();
	//AVCodec * codec = avcodec_find_decoder( CODEC_ID_MPEG2VIDEO );
	extern AVCodec mpeg2video_decoder;
	AVCodec * codec = &mpeg2video_decoder;
	avctx = avcodec_alloc_context();
	pic = avcodec_alloc_frame();
	avctx->flags |= CODEC_FLAG_TRUNCATED | CODEC_FLAG_LOW_DELAY;
	
	err = avcodec_open( avctx, codec ) < 0;
	TGOOD

	bool fileNotSpecced = (gFileToOpen == NULL);
	if (fileNotSpecced) gFileToOpen =
		"/Users/johnd/DVB/Accellent/DummyDVD/VIDEO_TS/VTS_01_1.VOB";		// orig
//		"/Users/johnd/DVB/Accellent/subst.mpg";								// fixed!
//		"/Users/johnd/Desktop/grabs/Tru Calling 021104.mpg";				// ok
//		"/Users/johnd/Desktop/grabs/9HDLoop(video).mpg";					// crash! (kernel infinite loop)
//		"/Users/johnd/DVB/Accellent/DummyDVD2/VIDEO_TS/VTS_01_1.VOB";		// HD DVD unspecable :(
//		"/Users/johnd/Desktop/grabs/Satellite PCTV-Australia Thu 29 Jul 02.04.07 2004.mpg"; // fixed!
//		"/Users/johnd/Desktop/DVDMaking/ITV 1 DVD/VIDEO_TS/VTS_01_1.VOB";   // fixed!
//		"/Users/johnd/Desktop/DVDMaking/BBC Two DVD/VIDEO_TS/VTS_01_1.VOB"; // ok
//		"/Users/johnd/Desktop/DVDMaking/BBC TWO.mpeg";						// fixed!
//		"/Users/johnd/DVB/Accellent/720p-VIDEO_TS/VIDEO_TS/VTS_01_1.VOB";	// fixed!
//		"/Users/johnd/DVB/Accellent/1080i-fromTS/VIDEO_TS/VTS_01_1.VOB";	// fixed! mostly

	FILE * f = fopen( gFileToOpen, "rb" );
	if (f == NULL)
	{
		NSAlert * al = [NSAlert
			alertWithMessageText:@"Could not open input file"
			defaultButton:@"Yessir!"
			alternateButton:NULL
			otherButton:NULL
			informativeTextWithFormat:fileNotSpecced?
				@"Specify file by drag'n'drop or command line argument":
				@"Unable to open file '%s'", gFileToOpen ];
		[al runModal];
		return;
	}
	uint64 biginbufsize = lseek( fileno(f), 0, SEEK_END );
	lseek( fileno(f), 0, SEEK_SET );
	int inbufsize = (biginbufsize > 64*1024*1024) ? 64*1024*1024 : int(biginbufsize);
	printf( "reading %d bytes from file '%s'\n", inbufsize, gFileToOpen );
	char * inbuf = new char[inbufsize];
	int inbufamt = fread( inbuf, 1, inbufsize, f );
	fclose( f );
	
	// welcome to the world's smallest MPEG2 demuxer (actually prolly not the smallest)
	char * streamb = new char[inbufamt];
	bool ingood = false;
	int glen;
	char * ib = inbuf, *sb = streamb;
	while (ib < inbuf+inbufamt-4096)
	{
		if (!ingood)
		{
			if (((*(uint32*)ib) >> 8) != 1)
			{
				ib++;
				continue;
			}

			uint8 sid = *(uint32*)ib;
			//printf( "sid %d\n", sid );
			if (sid == 0xBA)	// pack header
			{
				ib += 14;
				continue;
			}

			// parse header as if it were a pes packet
			int hlen = 9+ib[8];
			glen = 6+((uint16*)ib)[2] - hlen;
			
			// skip audio pes (REQUIRED as I found one containing 00 00 01 E3!)
			if (sid >= 0xB0 && sid <= 0xCF) { ib += hlen + glen; continue; }
			// skip anything else and hope it doesn't emulate startcodes
			if (sid < 0xE0 || sid > 0xEF) { ib++; continue; }
			
			ib += hlen; // skip header, just copy payload to sb
			ingood = true;
		}
		else
		{
			*sb++ = *ib++;
			if (--glen == 0) ingood = false;
		}
	}
	
	gSBBeg = (uint8*)streamb;
	gSBEnd = (uint8*)sb;
	
	// find out the size of the video by decoding the first frame
	uint8 * sbcon = gSBBeg;
	{
		char * dummyBuf = new char[8*1024*1024];
		gDVDVState.frame = (DVDV_Frame*)dummyBuf;

		int got_picture = 0;
		for (int i = 0; i < 32 && gSBEnd-sbcon > 256*1024 && !got_picture; i++)
		{
			gDVDVState.mb = (DVDV_MBInfo*)gDVDVState.dct = (DVDV_DCTElt*)gDVDVState.cbp = dummyBuf;

			int ulen = avcodec_decode_video( avctx, pic, &got_picture, sbcon, gSBEnd-sbcon );
			if (ulen > 0) sbcon += ulen;
			printf( "looking for first frame: used %d bytes\n", ulen );
		}
		
		delete [] dummyBuf;
		
		err = avcodec_close( avctx ) < 0;
		TGOOD

		err = avcodec_open( avctx, codec ) < 0;
		TGOOD
	}
	gRealRect[2] = avctx->height;
	gRealRect[3] = avctx->width;
	if (gRealRect[2] <= 0 || gRealRect[3] <= 0)
	{
		NSAlert * al = [NSAlert
			alertWithMessageText:@"Could not find first frame in that file"
			defaultButton:@"Capiche"
			alternateButton:NULL
			otherButton:NULL
			informativeTextWithFormat:@"Searched %d bytes in '%s'", sbcon-gSBBeg, gFileToOpen];
		[al runModal];
		return;
	}
	printf( "found first frame: width %d height %d\n", gRealRect[3], gRealRect[2] );
	
	// calculate aspect ratio (from Displayer.cpp):
	AVRational fullFrameSAR;
	//AVPanScan * pan_scan = avctx->coded_frame->pan_scan;
	//if (pan_scan->width == 0 || pan_scan->height == 0)
		fullFrameSAR = avctx->sample_aspect_ratio;
	//else	// keep it simple for now
	//	fullFrameSAR = av_div_q(
	//		av_mul_q( avctx->sample_aspect_ratio,
	//			(AVRational){pan_scan->width,pan_scan->height} ),
	//		(AVRational){gRealRect[3],gRealRect[2]} );
	float sampleAspectRatio = av_q2d( fullFrameSAR );
	
	// record both decoded and display sizes
	NSSize decodedSize = NSMakeSize( gRealRect[3], gRealRect[2] );
	NSSize displaySize = NSMakeSize( decodedSize.width*sampleAspectRatio, decodedSize.height );
	//[window setContentSize:displaySize];
	[window setContentSize:decodedSize];	// keep it at decoded size for now

	// first try opening the DVD driver ourselves
	/*
	DVDVideoContext * pCtx;
	DVDVideoSize sz;
	DVDOpenRes someRes, someRes2, someRes3;
	int er2 = DVDVideoOpenDevice( CGMainDisplayID(), 0, 0, 0, &someRes, &someRes2, &someRes3 );
	printf( "er2 %d pCtx:%p sz %08X %08X someRes 0x%08X 0x%04X 0x%04X\n",
		er2, pCtx, sz.x, sz.y, someRes.a, someRes.b, someRes.c );
	// umm, no! We'd have to do lots of nasty private CG calls.. like CGSAddSurface :(

	return;
	*/

	// now init it
	err = DVDInitialize();
	TGOOD

	// get the function table that DVDPlayback uses to call DVDVideo
	uint32 * dvdFuncTable = (uint32*)(decodeCallerStart+0x6b984);

	// install loggers
	void * logfromtbl[64];
	void * logtotbl[64];
	int lognum = LogEnd::addLog( logfromtbl, logtotbl );
	int logmiss = 0;
	for (int i = 0; i < lognum; i++)
	{
		int j;
		for (j = 0; j < 64; j++)
		{
			if (((void*)dvdFuncTable[j]) == logfromtbl[i])
			{
				(void*&)(dvdFuncTable[j]) = logtotbl[i];
				break;
			}
		}
		if (j == 64)
		{
			//printf( "Could not find function %d to log\n", i );
			++logmiss;
		}
	}
	printf( "Installed %d/%d loggers in DVDPlayback table\n", lognum-logmiss, lognum );

	// replace the OpenDevice function with our own so gDVDContext doesn't get stale
	for (int j = 0; j < 64; j++)
	{
		if (((void*)dvdFuncTable[j]) == (void*)&DVDLogger_OpenDevice)
		{
			gOrigOpenDevice = (DVDVideoOpenDeviceFunc)dvdFuncTable[j];
			dvdFuncTable[j] = (uint32)(void*)DVDVideoOpenDevice_filter;
			break;
		}
	}

	// now proceed with standard DVDPlayback init
	err = DVDSetVideoWindowID( [window windowNumber] );
	TGOOD
	printf( "Done SetVideoWindowID(0x%08X)\n", [window windowNumber] );
	err = DVDSetVideoDisplay( CGMainDisplayID() );
	TGOOD	
	printf( "Done SetVideoDisplay\n" );

	// replace the SetMPRects function with our own
	DVDSetMPRectsType * dvdFuncSetMPRects = (DVDSetMPRectsType*)&dvdFuncTable[6];
	gOrigSMPR = *dvdFuncSetMPRects;
	*dvdFuncSetMPRects = DVDSetMPRects_collect;

	// call a function which calls SetMPRects
	NSRect frmGlb = [window frame];
	NSRect conGlb = [window contentRectForFrameRect:[window frame]];
	Point conOrg = { (uint16)((frmGlb.origin.y+frmGlb.size.height)-(conGlb.origin.y+conGlb.size.height)),
		(uint16)(conGlb.origin.x-frmGlb.origin.x) };
	Rect windowRect = { conOrg.v, conOrg.h, conOrg.v+gRealRect[2], conOrg.h+gRealRect[3] };
	err = DVDSetVideoBounds( &windowRect );
	TGOOD

	// restore the original SetMPRects function
	/* Jan 2006: Can't do this until correct device is collected!
	*dvdFuncSetMPRects = gOrigSMPR;
	printf( "Done SetVideoBounds\n" );
	printf( "collected context is 0x%08X\n", (uint)gDVDContext );
	*/

	// Note: it seems we have lost the DVDLogger_Deinterlace hook by here...
	// but since something is working now, code to reinstate it can wait
	// (before I moved getting the func table above SetVideoDisplay it was fine)

#ifdef PLAY_WITH_DVDPLAYBACK
	char * vtsAt = strstr( gFileToOpen, "/VIDEO_TS" );
	if (vtsAt == NULL)
	{
		NSAlert * al = [NSAlert
			alertWithMessageText:@"DVDPlayback requires a proper VIDEO_TS folder"
			defaultButton:@"Capiche"
			alternateButton:NULL
			otherButton:NULL
			informativeTextWithFormat:@"The file '%s' is not (or is not in) a VIDEO_TS folder", gFileToOpen];
		[al runModal];
		return;
	}
	NSURL * url = [NSURL fileURLWithPath:[NSString
		stringWithCString:gFileToOpen length:vtsAt+9-gFileToOpen]];
	FSRef fsr;
	CFURLGetFSRef( (CFURLRef)url, &fsr );
	err = DVDOpenMediaFile( &fsr );
	TGOOD

	// redirect all decode calls to go through us first
	DVDDecodeType * dvdFuncDecode = (DVDDecodeType*)&dvdFuncTable[10];
	gOrigDecoder = *dvdFuncDecode;
	*dvdFuncDecode = DVDDecode_filter;

#else

	DVDDecodeType * dvdFuncDecode = (DVDDecodeType*)&dvdFuncTable[10];
	gOrigDecoder = *dvdFuncDecode;
	
	*dvdFuncDecode = DVDDecode_subst;

#ifdef LOWLEVEL_OURSELF
	pthread_create( &gDecThread, NULL, &AccellentDVDDecodeThread, NULL );
#else
	AccellentDVDDecodeThread( NULL );
#endif

#endif

	// start a timer to call DVDIdle
	[[NSTimer scheduledTimerWithTimeInterval:0.01
		target:self
		selector:@selector(idleTimer:)
		userInfo:nil
		repeats:YES] retain];

}


#ifndef PLAY_WITH_DVDPLAYBACK
static void * AccellentDVDDecodeThread( void * /*args*/ )
{
	OSStatus err;
	int step = 0;

	// find the appropriate dummy DVD
	bool needsDummy = true;
#ifdef LOWLEVEL_OURSELF

	NSAutoreleasePool * arpool = [[NSAutoreleasePool alloc] init];


	// only need it if the default one isn't appropriate
	//if (gDVDContext != NULL) needsDummy = false;
	// for now always use the dummy...
	if (gDVDContext != NULL) gDVDContext = NULL;
#endif
	
	if (needsDummy)
	{
		DummyDVD * dummy = NULL;
		for (uint i = 0; i < sizeof(gDummyDVDs)/sizeof(gDummyDVDs[0]); ++i)
		{
			if (gDummyDVDs[i].width >= gRealRect[3] && gDummyDVDs[i].height >= gRealRect[2])
			{
				dummy = &gDummyDVDs[i];
				break;
			}
		}
		if (dummy == NULL)
		{
			NSAlert * al = [NSAlert
				alertWithMessageText:@"No dummy DVD found for a stream of that resolution"
				defaultButton:@"Damn."
				alternateButton:NULL
				otherButton:NULL
				informativeTextWithFormat:@"Resolution is %dx%d", gRealRect[3], gRealRect[2] ];
			[al runModal];
			return NULL;
		}

		NSString * bundlePath = [[[NSBundle mainBundle] bundlePath] stringByDeletingLastPathComponent];
		if ([[bundlePath lastPathComponent] isEqual:@"build"])
			bundlePath = [bundlePath stringByDeletingLastPathComponent];
		NSString * dummyPath = [bundlePath stringByAppendingPathComponent:[NSString stringWithCString:dummy->path]];
		NSURL * url = [NSURL fileURLWithPath:dummyPath];
		FSRef fsr;
		CFURLGetFSRef( (CFURLRef)url, &fsr );
		err = DVDOpenMediaFile( &fsr );
		TGOOD
		printf( "\nOpened dummy media file '%s'\n\n", dummy->path );
	}

#ifdef LOWLEVEL_OURSELF

	printf( "start of low-level code (in separate thread)\n" );

	// wait until we get a device of the correct size
	DVDPlay();
	int waitCount = 0;
	while (gDVDContext == NULL)
	{
		DVDIdle();
		usleep( 50*1000 );
		waitCount++;
		
		if (waitCount > 100)
		{
			NSAlert * al = [NSAlert
				alertWithMessageText:@"Dummy DVD failed to generate acceptable context"
				defaultButton:@"Damn."
				alternateButton:NULL
				otherButton:NULL
				informativeTextWithFormat:@"Waited 5 seconds"];
			[al runModal];
			DVDStop();
			return NULL;
		}
	}
	DVDPause();
	printf( "Gathered device from dummy media file\n" );
	usleep( 100*1000 );
	printf( "Starting to feed device ourself...\n\n" );



	err = DVDVideoSetMVLevel( gDVDContext, 0 );
	TGOOD

	err = DVDVideoSetMPRects( gDVDContext, gRealRect, gSurfaceID, gSurfaceID );
	TGOOD
	
	err = DVDVideoClearMP( gDVDContext );
	TGOOD

	err = DVDVideoSetMPRects( gDVDContext, gRealRect, gSurfaceID, gSurfaceID );
	TGOOD

	err = DVDVideoEnableMP( gDVDContext, true );
	TGOOD
#endif


	int numMBs = (gRealRect[2]/16)*(gRealRect[3]/16);
	//struct DVDV_CurPtrs begPtrs;
	begPtrs.mb = new DVDV_MBInfo[2*numMBs];
	begPtrs.dct = new DVDV_DCTElt[2*numMBs*6*64];
	begPtrs.cbp = new uint8_t[2*numMBs];
	begPtrs.frame = new DVDV_Frame;
	uint8 * begPtr_subp = new uint8[8*1024*1024];
	memset( begPtr_subp, 0, 8*1024*1024 );


#ifdef LOWLEVEL_OURSELF
	
	DecodeParams decParams;
	memset( &decParams, 0, sizeof(decParams) );
	decParams.pictType = 0;
	decParams.sevenSixEight = 768;
	decParams.dstBuf = 0;
	decParams.srcBufL = 0;
	decParams.srcBufR = 0;
	decParams.mbInfo = (MBInfo*)begPtrs.mb;
	decParams.dctSpecs = (DCTSpec*)begPtrs.dct;
	decParams.cbp = begPtrs.cbp;
	decParams.p4 = begPtr_subp;

	/*
	CompletionInfo * defCI = new CompletionInfo();
	memset( defCI, 0, sizeof(*defCI) );
	
	CompletionInfo & decCI = *defCI;
	decCI.funcTable = NULL;
	decCI.unk1 = NULL;
	decCI.frameNumberToDisplay = 0;
	decCI.frameDataToDisplay = NULL;
	//decParams.completionInfo = &decCI;  // or try setting this to NULL...
	decParams.completionInfo = NULL;
	*/

	int bufPast = 0x100, bufFuture = 0x100;
	int bufRecentB = 0x100;
	
	uint64 displayTime = getusecs();

	int frame = 0;
	while (gSBEnd-gSBBeg > 256*1024 && !gStop)
	{
		gDVDVState = begPtrs;
		
		int got_pic = 0;
		int ulen = avcodec_decode_video( avctx, pic, &got_pic, gSBBeg, gSBEnd-gSBBeg );
		if (ulen > 0) gSBBeg += ulen;
		if (!got_pic)
		{
			if (ulen > 0) continue;
			// otherwise no progress being made
			printf( "no picture from ffmpeg and no data consumed - bye!\n" );
			break;
		}		

		if (gDVDVState.mb == begPtrs.mb)
		{
			printf( "didn't decode any macroblocks so skipping frame\n" );
			continue;	// happens when there are bad B frames in there
		}

		printf( "used %d from ffmpeg yielding pict_type %c\n", ulen, s_pictTypes[ pic->pict_type ] );

		decParams.pictType = pic->pict_type;
		decParams.alternateScan = begPtrs.frame->alternate_scan;
		
		//printf( "intra vlc format %d alternate scan %d\n",
		//	begPtrs.frame->intra_vlc_format, begPtrs.frame->alternate_scan );

		uint displayBuf = ~0;
		switch (pic->pict_type)
		{
			case 1: // I frame
			case 2: // P frame
				// find a buffer that isn't the current future buffer
				for (int i = 0; i < 4; i++)
				{
					if (bufFuture == i || bufRecentB == i) continue;
					decParams.dstBuf = i;
					break;
				}
				// what was in the future is now in the past
				bufPast = bufFuture;
				// so display it now
				displayBuf = bufFuture;
				// and we should be using that if this is a P frame
				decParams.srcBufL = decParams.srcBufR = bufPast;
				// but it is not yet time for the result of this decoding
				bufFuture = decParams.dstBuf;
				break;
			case 3: // B frame
				// find a buffer that wasn't used recently
				for (int i = 0; i < 4; i++)
				{
					if (bufFuture == i || bufPast == i || bufRecentB == i) continue;
					decParams.dstBuf = i;
					break;
				}
				// and remember that we used it recently
				bufRecentB = decParams.dstBuf;
				// the present draws on both the past and the future
				decParams.srcBufL = bufPast;
				decParams.srcBufR = bufFuture;
				// and it is also the one to display
				displayBuf = decParams.dstBuf;
				break;
			default:
				printf( "unknown picture type %d\n", pic->pict_type );
				continue;
		}
		err = DVDVideoDecode( gDVDContext, &decParams, gRealRect, 0 );
		//err = DVDDecode_filter( gDVDContext, &decParams, (uint16*)gRealRect, 0 );
		//err = DVDLogger_Decode( gDVDContext, &decParams, (uint16*)gRealRect, 0 );
		TGOOD
		
		printf( "sent to dvd decoding: dst %d past %d future %d\n",
			decParams.dstBuf, decParams.srcBufL, decParams.srcBufR );

		
		if (frame >= 1 && displayBuf < 4)
		{
			DeinterlaceParams1 dp1;
			memset( &dp1, 0, sizeof(dp1) );
			dp1.buf1 = displayBuf;
			dp1.buf2 = displayBuf;
			dp1.w1 = 1;
			dp1.w2 = 1;
			dp1.w3 = 2;
			DeinterlaceParams2 dp2;
			memset( &dp2, 0, sizeof(dp2) );
			dp2.unk1 = 0x00020000;
			dp2.usedValue = 1;
			err = DVDVideoDeinterlace( gDVDContext, &dp1, &dp2, 0 );
			TGOOD
			//printf( "sent to dvd deinterlacing\n" );
		}
		
		uint64 currentTime = getusecs();
		if (displayTime > currentTime)
			usleep( uint32(displayTime - currentTime) );
		displayTime += 1000000 / avctx->frame_rate;

		if (frame >= 1 && displayBuf < 4)
		{		// kernel panics if buf > 4... DON'T stuff it up!
			ShowBufferParams sp;
			memset( &sp, 0, sizeof(sp) );
			sp.h1 = 2;
			sp.w = 1;
			err = DVDVideoShowMPBuffer( gDVDContext, displayBuf, &sp, 0 );
			TGOOD
			printf( "displayed buffer %d\n", displayBuf );
		}
		
		frame++;
	}
	
	printf( "end of low-level code\n" );
	
	[arpool release];
#endif  // LOWLEVEL_OURSELF

	return 0;
}
#endif  // PLAY_WITH_DVDPLAYBACK


- (void)applicationWillTerminate:(NSNotification *)notification
{
#ifndef PLAY_WITH_DVDPLAYBACK
	if (gDecThread != 0)
	{
		printf( "trying to stop decoder thread...\n" );
		gStop = true;
		pthread_join( gDecThread, NULL );
		printf( "stopped decoder thread\n" );
	}
#endif

	OSStatus err;
	int step = 1000;

	err = DVDCloseMediaFile();
	TGOOD
	err = DVDDispose();
	TGOOD
}

- (void)idleTimer:(NSTimer *)timer
{
#ifndef LOWLEVEL_OURSELF
	DVDIdle();
	if (!playingNow)
	{
		playingNow = YES;
		printf( "\nFirst DVDIdle\n\n" );
		DVDPlay();
		printf( "\nDone DVDPlay\n\n" );
	}
	
	(void)getusecs;
#endif
}

- (void)windowWillClose:(NSNotification *)notification
{
	printf( "quitting app since main window closed\n" );
	[NSApp terminate:self];
}


@end